/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.identity;

import java.util.UUID;
import java.util.stream.Stream;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.examination.ExaminableProperty;
import me.lucko.spark.lib.adventure.identity.Identities;
import me.lucko.spark.lib.adventure.identity.IdentityImpl;
import me.lucko.spark.lib.adventure.key.Key;
import me.lucko.spark.lib.adventure.pointer.Pointer;
import me.lucko.spark.lib.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public interface Identity
extends Examinable {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key("adventure", "name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key("adventure", "uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key("adventure", "display_name"));

    @NotNull
    public static Identity nil() {
        return Identities.NIL;
    }

    @NotNull
    public static Identity identity(@NotNull UUID uuid) {
        if (uuid.equals(Identities.NIL.uuid())) {
            return Identities.NIL;
        }
        return new IdentityImpl(uuid);
    }

    @NotNull
    public UUID uuid();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("uuid", this.uuid()));
    }
}

